#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Kaleidoscope 42Mod01.fsh   by   surjikal 
//https://www.shadertoy.com/view/.....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Hacked together using code from:
// https://graphicdesign.stackexchange.com/questions/88165/program-for-image-kaleidoscope-mirror-effect-similar-to-adobe-capture-pattern-tr

const float PI = 3.14159265359;
const int numberOfAxis = 6;



int intModulo(float a,float b) {
    float m = mod(a, b);
    return int(m+0.5);
}

vec4 colorCycle(vec4 inputColor, float offset) {

	float U = 1.0 + cos(offset * 0.9) * 3.0;
	float W = 1.0 + sin(offset * 0.9) * 3.0;
    vec4 outputColor;

	outputColor.r = (.299+.701*U+.168*W)*inputColor.r
	+ (.587-.587*U+.330*W)*inputColor.g
	+ (.114-.114*U-.497*W)*inputColor.b;
	outputColor.g = (.299-.299*U-.328*W)*inputColor.r
	+ (.587+.413*U+.035*W)*inputColor.g
	+ (.114-.114*U+.292*W)*inputColor.b;
	outputColor.b = (.299-.3*U+1.25*W)*inputColor.r
	+ (.587-.588*U-1.05*W)*inputColor.g
	+ (.114+.886*U-.203*W)*inputColor.b;
    outputColor.a = inputColor.a;
	
	return outputColor;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float angleFrac = (2.0 * PI) / float(2 * numberOfAxis);

    vec2 c = (fragCoord - 0.5 * iResolution.xy) / iResolution.y;

    // convert to polar coordinates 
    float phi = abs(atan(c.y, c.x)); 
    float r = length(c);

    int count = int(phi / angleFrac);

    phi = mod(phi, angleFrac);
    if ( intModulo(float(count),2.0) == 1) {
      phi = angleFrac - phi;
    }

    float x = r * cos(phi);
    float y = r * sin(phi);

    float frame = iTime * 0.05;
    float zoom = 1.0 + sin(iTime * 0.3) / 3.0;
	
    vec2 cc = (vec2(x,y) * zoom) + frame; //map to range [0.0, 1.0]
    vec4 color = texture2D(iChannel0, cc);
    fragColor = colorCycle(color, iTime);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

